SCORETEST <- function(mE, mX, mZ, flag)
##################################################################
# R code: Exercise 11.5(c) 
# File: scoretest.r
# Coded by: Yukai Yang
# 
# LM-type linearity test statistic versus LVSTAR nonlinearity
# INPUT:  mE (matrix of residuals from VAR(p)-fit)
#         mX (matrix of regressors)
#         mZ (auxiliary regression matrix)
# OUTPUT: LM test statistic, first-order approximation
#         F test statistic (rescaled LM-type test statistic)
#           correcting a mistake in the degrees of freedom iDF2
#         Wilks' test statistic
#         Rao's F test statistic
#
# Reference:
# Yang, Y. (2012). Modelling Nonlinear Vector Economic Time Series, 
#   PhD thesis, Aarhus University, Denmark. Available at:
#   http://pure.au.dk/portal/files/45638557/Yukai_Yang_PhD_Thesis.pdf.
###################################################################
{
  iT = dim(mE)[1]
  ip = dim(mE)[2]
  ix = dim(mX)[2]
  iz = dim(mZ)[2]
  mE = data.matrix(mE)
  mX = data.matrix(mX)  
  mZ = data.matrix(mZ)  
  
  iK   = ix + iz
  iDF  = iz * ip
  RSS0 = t(mE)%*%mE
  
# RSS0
  mXX  = cbind(mX, mZ)
  mU   = svd(mXX)$u
  mR   = mE - mU%*%t(mU)%*%mE
  RSS1 = t(mR)%*%mR

# RSS1
  R0 = svd(RSS0)$d
  R1 = svd(RSS1)$d
  LM = list()
  FT = list()
  WK = list()
  RA = list()

  if((flag%%2)==1){
# LM test statistic
     dTR     = sum(diag(solve(RSS0)%*%RSS1))
     test    = iT * (ip-dTR)
     LM$pval = 1 - pchisq(test,df=iDF)
     LM$test = test
     LM$df   = iDF
# Rescaled test statistic
     iDF1    = iDF
     iDF2    = ip * iT - iK  # Correcting a mistake: ip*(iT-iK)
     test    = LM$test * (iT - iK)/(iT * LM$df)
     FT$pval = 1 -pf(test,df1=iDF1,df2=iDF2)
     FT$test = test
     FT$df1  = iDF1
     FT$df2  = iDF2
   }
flag = flag%/%2
  if((flag%%2)==1){
# Wilks' test statistic
     Lambda  = sum(log(R1)) - sum(log(R0))
     Lambda  = Lambda * ((ip + iz + 1)*.5 + ix - iT)
     WK$pval = 1 - pchisq(Lambda,df=iDF)
     WK$test = Lambda
     WK$df   = iDF
   }
flag = flag%/%2
  if((flag%%2)==1){
# Rao's test statistic
     iN      = iT - ix - (ip+iz+1)*.5
     is      = sqrt( (iz*iz*ip*ip-4)/(ip*ip+iz*iz-5))
     iDF1    = iDF
     iDF2    = iN*is - iz*ip*.5 + 1
     RAO     = exp((sum(log(R0))-sum(log(R1)))/is)-1
     RAO     = RAO *iDF2 /iDF1
     RA$pval = 1 - pf(RAO,df1=iDF1,df2=iDF2)
     RA$test = RAO
     RA$df1  = iDF1
     RA$df2  = iDF2
  }
return(list(LM = LM, FT = FT, WK = WK, RA = RA))
}
